/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import noppes.npcs.LogWriter;
import noppes.npcs.client.model.Model2DRenderer;
import noppes.npcs.client.renderer.ModelBuffer;
import noppes.npcs.controllers.data.MarkData;
import org.lwjgl.opengl.GL11;

public class MarkRenderer {
    public static int[] displayList = new int[]{-1, -1, -1, -1, -1, -1, -1};
    public static ResourceLocation markCross = new ResourceLocation("customnpcs", "textures/marks/cross.png");
    public static ResourceLocation markExclamation = new ResourceLocation("customnpcs", "textures/marks/exclamation.png");
    public static ResourceLocation markPointer = new ResourceLocation("customnpcs", "textures/marks/pointer.png");
    public static ResourceLocation markQuestion = new ResourceLocation("customnpcs", "textures/marks/question.png");
    public static ResourceLocation markSkull = new ResourceLocation("customnpcs", "textures/marks/skull.png");
    public static ResourceLocation markStar = new ResourceLocation("customnpcs", "textures/marks/star.png");
    public static boolean needReload = false;
    private static final FloatBuffer COLOR_BUFFER = GLAllocation.func_74529_h((int)4);
    private static final Vec3d LIGHT0_POS = new Vec3d(0.2, 1.0, -0.7).func_72432_b();
    private static final Vec3d LIGHT1_POS = new Vec3d(-0.2, 1.0, 0.7).func_72432_b();

    public static void render(EntityLivingBase entity, double x, double y, double z, MarkData.Mark mark) {
        try {
            int list;
            GlStateManager.func_179094_E();
            int color = mark.color;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
            GlStateManager.func_179137_b((double)x, (double)(y + (double)entity.field_70131_O + 0.6), (double)z);
            GlStateManager.func_179114_b((float)(-entity.field_70759_as), (float)0.0f, (float)1.0f, (float)0.0f);
            switch (mark.type) {
                case 2: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(markExclamation);
                    break;
                }
                case 3: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(markPointer);
                    break;
                }
                case 4: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(markSkull);
                    break;
                }
                case 5: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(markCross);
                    break;
                }
                case 6: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(markStar);
                    break;
                }
                default: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(markQuestion);
                }
            }
            int n = list = mark.is3D() ? displayList[mark.type] : displayList[0];
            if (needReload || list < 0) {
                needReload = false;
                if (mark.is3D()) {
                    String name;
                    switch (mark.type) {
                        case 2: {
                            name = "exclamation";
                            break;
                        }
                        case 3: {
                            name = "pointer";
                            break;
                        }
                        case 4: {
                            name = "skull";
                            break;
                        }
                        case 5: {
                            name = "cross";
                            break;
                        }
                        case 6: {
                            name = "star";
                            break;
                        }
                        default: {
                            name = "question";
                        }
                    }
                    MarkRenderer.displayList[mark.type] = list = ModelBuffer.getDisplayList(new ResourceLocation("customnpcs:models/util/" + name + ".obj"), null, null);
                } else {
                    list = GLAllocation.func_74526_a((int)1);
                    GL11.glNewList((int)list, (int)4864);
                    GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)0.0);
                    Model2DRenderer.renderItemIn2D(Tessellator.func_178181_a().func_178180_c(), 0.0f, 0.0f, 1.0f, 1.0f, 32, 32, 0.0625f);
                    GL11.glEndList();
                    MarkRenderer.displayList[0] = list;
                    if (mark.is3D()) {
                        MarkRenderer.displayList[mark.type] = list;
                    }
                }
            }
            if (list >= 0) {
                if (mark.isRotate()) {
                    GlStateManager.func_179114_b((float)((float)(entity.field_70170_p.func_82737_E() % 360L) / 0.25f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (mark.is3D() && displayList[mark.type] != displayList[0]) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                    GL11.glEnable((int)2896);
                    GL11.glEnable((int)16384);
                    GL11.glEnable((int)16385);
                    GL11.glEnable((int)2903);
                    GlStateManager.func_179104_a((int)1032, (int)5634);
                    GlStateManager.func_187438_a((int)16384, (int)4611, (FloatBuffer)MarkRenderer.setColorBuffer((float)MarkRenderer.LIGHT0_POS.field_72450_a, (float)MarkRenderer.LIGHT0_POS.field_72448_b, (float)MarkRenderer.LIGHT0_POS.field_72449_c, 0.0f));
                    GlStateManager.func_187438_a((int)16384, (int)4609, (FloatBuffer)MarkRenderer.setColorBuffer(red *= 0.5f, green *= 0.5f, blue *= 0.5f, 1.0f));
                    GlStateManager.func_187438_a((int)16384, (int)4608, (FloatBuffer)MarkRenderer.setColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                    GlStateManager.func_187438_a((int)16384, (int)4610, (FloatBuffer)MarkRenderer.setColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                    GlStateManager.func_187438_a((int)16385, (int)4611, (FloatBuffer)MarkRenderer.setColorBuffer((float)MarkRenderer.LIGHT1_POS.field_72450_a, (float)MarkRenderer.LIGHT1_POS.field_72448_b, (float)MarkRenderer.LIGHT1_POS.field_72449_c, 0.0f));
                    GlStateManager.func_187438_a((int)16385, (int)4609, (FloatBuffer)MarkRenderer.setColorBuffer(red, green, blue, 1.0f));
                    GlStateManager.func_187438_a((int)16385, (int)4608, (FloatBuffer)MarkRenderer.setColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                    GlStateManager.func_187438_a((int)16385, (int)4610, (FloatBuffer)MarkRenderer.setColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                    GL11.glShadeModel((int)7424);
                    GlStateManager.func_187424_a((int)2899, (FloatBuffer)MarkRenderer.setColorBuffer(red, green, blue, 1.0f));
                }
                GlStateManager.func_179148_o((int)list);
            }
            GlStateManager.func_179121_F();
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    private static FloatBuffer setColorBuffer(float red, float green, float blue, float alpha) {
        COLOR_BUFFER.clear();
        COLOR_BUFFER.put(red).put(green).put(blue).put(alpha);
        COLOR_BUFFER.flip();
        return COLOR_BUFFER;
    }
}

